<?php
/**
 * Switch Business Handler
 */
require_once 'config.php';
requireLogin();

$businessId = intval($_GET['id'] ?? 0);
$redirect = $_GET['redirect'] ?? 'dashboard.php';

if ($businessId) {
    // Verify user has access to this business
    $db = getDB();
    $stmt = $db->prepare("
        SELECT b.id FROM businesses b
        JOIN business_users bu ON b.id = bu.business_id
        WHERE b.id = ? AND bu.user_id = ? AND b.is_active = 1
    ");
    $stmt->execute([$businessId, $_SESSION['user_id']]);
    
    if ($stmt->fetch()) {
        $_SESSION['current_business_id'] = $businessId;
        setFlash('success', 'Bisnis berhasil dipilih');
    } else {
        setFlash('error', 'Anda tidak memiliki akses ke bisnis ini');
    }
}

redirect($redirect);
