<?php
/**
 * Emergency Password Reset
 * Hapus file ini setelah digunakan untuk keamanan!
 */

// Error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Database configuration
$dbHost = 'localhost';
$dbUser = 'root';
$dbPass = '';
$dbName = 'sistem_keuangan_terpadu';

$message = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = $_POST['email'] ?? '';
    $newPassword = $_POST['new_password'] ?? '';
    $confirmPassword = $_POST['confirm_password'] ?? '';
    
    if (empty($email) || empty($newPassword)) {
        $error = 'Email dan password baru wajib diisi';
    } elseif ($newPassword !== $confirmPassword) {
        $error = 'Password tidak cocok';
    } elseif (strlen($newPassword) < 6) {
        $error = 'Password minimal 6 karakter';
    } else {
        try {
            $pdo = new PDO("mysql:host={$dbHost};dbname={$dbName};charset=utf8mb4", $dbUser, $dbPass, [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            ]);
            
            // Generate new hash
            $hash = password_hash($newPassword, PASSWORD_BCRYPT, ['cost' => 12]);
            
            // Update password
            $stmt = $pdo->prepare("UPDATE users SET password = ?, login_attempts = 0, locked_until = NULL WHERE email = ?");
            $stmt->execute([$hash, $email]);
            
            if ($stmt->rowCount() > 0) {
                $message = "Password untuk {$email} berhasil direset!";
            } else {
                $error = "Email {$email} tidak ditemukan";
            }
            
        } catch (PDOException $e) {
            $error = "Database error: " . $e->getMessage();
        }
    }
}

// Generate hash untuk reference
$sampleHash = password_hash('admin123', PASSWORD_BCRYPT, ['cost' => 12]);
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reset Password - Emergency</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background: #f8fafc;
            padding: 2rem;
        }
        .container {
            max-width: 500px;
        }
        .hash-box {
            background: #f1f5f9;
            padding: 1rem;
            border-radius: 0.5rem;
            font-family: monospace;
            font-size: 0.8rem;
            word-break: break-all;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="card">
            <div class="card-header bg-warning">
                <h5 class="mb-0">⚠️ Emergency Password Reset</h5>
            </div>
            <div class="card-body">
                <?php if ($message): ?>
                <div class="alert alert-success"><?php echo $message; ?></div>
                <?php endif; ?>
                
                <?php if ($error): ?>
                <div class="alert alert-danger"><?php echo $error; ?></div>
                <?php endif; ?>
                
                <form method="POST" action="">
                    <div class="mb-3">
                        <label class="form-label">Email User</label>
                        <input type="email" class="form-control" name="email" required 
                               placeholder="admin@admin.com" value="admin@admin.com">
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Password Baru</label>
                        <input type="password" class="form-control" name="new_password" required 
                               placeholder="Min 6 karakter">
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Konfirmasi Password</label>
                        <input type="password" class="form-control" name="confirm_password" required>
                    </div>
                    
                    <button type="submit" class="btn btn-warning w-100">
                        Reset Password
                    </button>
                </form>
                
                <hr>
                
                <h6>Sample Hash untuk 'admin123':</h6>
                <div class="hash-box"><?php echo $sampleHash; ?></div>
                <small class="text-muted">Copy hash ini ke database jika diperlukan</small>
                
                <div class="mt-4 alert alert-danger">
                    <strong>⚠️ PENTING:</strong> Hapus file ini setelah digunakan!
                </div>
                
                <a href="login.php" class="btn btn-secondary w-100">Kembali ke Login</a>
            </div>
        </div>
    </div>
</body>
</html>
