<?php
/**
 * Logout Handler
 */
require_once 'config.php';

// Log activity before logout
if (isLoggedIn()) {
    logActivity('logout', 'User logged out');
}

// Clear session
session_unset();
session_destroy();

// Clear remember cookie
if (isset($_COOKIE['remember_token'])) {
    setcookie('remember_token', '', time() - 3600, '/');
}

// Redirect to login
redirect('login.php');
