<?php
/**
 * Installation Wizard
 */
error_reporting(E_ALL);
ini_set('display_errors', 1);

$step = $_GET['step'] ?? 1;
$error = '';
$success = '';

// Check requirements
function checkRequirements() {
    $requirements = [
        'PHP >= 7.4' => version_compare(PHP_VERSION, '7.4.0', '>='),
        'PDO Extension' => extension_loaded('pdo'),
        'PDO MySQL' => extension_loaded('pdo_mysql'),
        'MySQLi' => extension_loaded('mysqli'),
        'JSON' => extension_loaded('json'),
        'Session' => extension_loaded('session'),
    ];
    return $requirements;
}

// Test database connection
function testDBConnection($host, $user, $pass, $name) {
    try {
        $pdo = new PDO("mysql:host={$host};charset=utf8mb4", $user, $pass, [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        ]);
        
        // Try to create database if not exists
        $pdo->exec("CREATE DATABASE IF NOT EXISTS `{$name}` CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
        
        return [true, 'Koneksi berhasil!'];
    } catch (PDOException $e) {
        return [false, $e->getMessage()];
    }
}

// Install database
function installDatabase($host, $user, $pass, $name) {
    try {
        $pdo = new PDO("mysql:host={$host};dbname={$name};charset=utf8mb4", $user, $pass, [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        ]);
        
        // Read SQL file
        $sql = file_get_contents('database.sql');
        
        // Execute SQL
        $pdo->exec($sql);
        
        return [true, 'Database berhasil diinstall!'];
    } catch (PDOException $e) {
        return [false, $e->getMessage()];
    }
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if ($step == 2) {
        $dbHost = $_POST['db_host'] ?? 'localhost';
        $dbUser = $_POST['db_user'] ?? '';
        $dbPass = $_POST['db_pass'] ?? '';
        $dbName = $_POST['db_name'] ?? 'sistem_keuangan_terpadu';
        
        list($connected, $message) = testDBConnection($dbHost, $dbUser, $dbPass, $dbName);
        
        if ($connected) {
            list($installed, $installMessage) = installDatabase($dbHost, $dbUser, $dbPass, $dbName);
            
            if ($installed) {
                // Create config file
                $configContent = "<?php
/**
 * Sistem Keuangan Terpadu - Configuration File
 */

// Error reporting (disable di production)
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Session configuration
ini_set('session.cookie_httponly', 1);
ini_set('session.use_only_cookies', 1);
ini_set('session.cookie_secure', 0);

// Database configuration
define('DB_HOST', '{$dbHost}');
define('DB_USER', '{$dbUser}');
define('DB_PASS', '{$dbPass}');
define('DB_NAME', '{$dbName}');

// Application configuration
define('APP_NAME', 'Sistem Keuangan Terpadu');
define('APP_VERSION', '1.0.0');
define('BASE_URL', '');
define('TIMEZONE', 'Asia/Jakarta');

// Security configuration
define('CSRF_TOKEN_NAME', 'csrf_token');
define('SESSION_LIFETIME', 7200);
define('MAX_LOGIN_ATTEMPTS', 5);
define('LOGIN_LOCKOUT_TIME', 900);

// Set timezone
date_default_timezone_set(TIMEZONE);

// Start session
session_start();

// Database connection class
class Database {
    private static \$instance = null;
    private \$connection;
    
    private function __construct() {
        try {
            \$this->connection = new PDO(
                \"mysql:host=\" . DB_HOST . \";dbname=\" . DB_NAME . \";charset=utf8mb4\",
                DB_USER,
                DB_PASS,
                [
                    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                    PDO::ATTR_EMULATE_PREPARES => false,
                ]
            );
        } catch (PDOException \$e) {
            die(\"Koneksi database gagal: \" . \$e->getMessage());
        }
    }
    
    public static function getInstance() {
        if (self::\$instance === null) {
            self::\$instance = new self();
        }
        return self::\$instance;
    }
    
    public function getConnection() {
        return \$this->connection;
    }
}

function getDB() {
    return Database::getInstance()->getConnection();
}

function generateCSRFToken() {
    if (!isset(\$_SESSION[CSRF_TOKEN_NAME])) {
        \$_SESSION[CSRF_TOKEN_NAME] = bin2hex(random_bytes(32));
    }
    return \$_SESSION[CSRF_TOKEN_NAME];
}

function validateCSRFToken(\$token) {
    return isset(\$_SESSION[CSRF_TOKEN_NAME]) && hash_equals(\$_SESSION[CSRF_TOKEN_NAME], \$token);
}

function csrfField() {
    return '<input type=\"hidden\" name=\"' . CSRF_TOKEN_NAME . '\" value=\"' . generateCSRFToken() . '\">';
}

function sanitizeInput(\$data) {
    return htmlspecialchars(strip_tags(trim(\$data)), ENT_QUOTES, 'UTF-8');
}

function encryptPassword(\$password) {
    return password_hash(\$password, PASSWORD_BCRYPT, ['cost' => 12]);
}

function verifyPassword(\$password, \$hash) {
    return password_verify(\$password, \$hash);
}

function formatRupiah(\$amount) {
    return 'Rp ' . number_format(\$amount, 0, ',', '.');
}

function formatDate(\$date, \$format = 'd M Y') {
    return date(\$format, strtotime(\$date));
}

function redirect(\$url) {
    header(\"Location: \" . \$url);
    exit();
}

function isLoggedIn() {
    return isset(\$_SESSION['user_id']) && !empty(\$_SESSION['user_id']);
}

function hasRole(\$roles) {
    if (!isLoggedIn()) return false;
    if (!is_array(\$roles)) \$roles = [\$roles];
    return in_array(\$_SESSION['user_role'], \$roles);
}

function requireLogin() {
    if (!isLoggedIn()) {
        \$_SESSION['error'] = 'Silakan login terlebih dahulu';
        redirect('login.php');
    }
}

function requireRole(\$roles) {
    requireLogin();
    if (!hasRole(\$roles)) {
        \$_SESSION['error'] = 'Anda tidak memiliki akses ke halaman ini';
        redirect('index.php');
    }
}

function setFlash(\$type, \$message) {
    \$_SESSION['flash'][\$type] = \$message;
}

function getFlash(\$type) {
    if (isset(\$_SESSION['flash'][\$type])) {
        \$message = \$_SESSION['flash'][\$type];
        unset(\$_SESSION['flash'][\$type]);
        return \$message;
    }
    return null;
}

function showFlash() {
    \$types = ['success', 'error', 'warning', 'info'];
    foreach (\$types as \$type) {
        \$message = getFlash(\$type);
        if (\$message) {
            \$alertClass = [
                'success' => 'alert-success',
                'error' => 'alert-danger',
                'warning' => 'alert-warning',
                'info' => 'alert-info'
            ][\$type];
            echo '<div class=\"alert ' . \$alertClass . ' alert-dismissible fade show\" role=\"alert\">';
            echo \$message;
            echo '<button type=\"button\" class=\"btn-close\" data-bs-dismiss=\"alert\"></button>';
            echo '</div>';
        }
    }
}

function logActivity(\$action, \$details = '') {
    \$db = getDB();
    \$stmt = \$db->prepare(\"INSERT INTO activity_logs (user_id, action, details, ip_address, created_at) VALUES (?, ?, ?, ?, NOW())\");
    \$stmt->execute([
        \$_SESSION['user_id'] ?? null,
        \$action,
        \$details,
        \$_SERVER['REMOTE_ADDR'] ?? null
    ]);
}
";
                
                file_put_contents('config.php', $configContent);
                
                $success = 'Instalasi berhasil! Silakan hapus file install.php untuk keamanan.';
                $step = 3;
            } else {
                $error = $installMessage;
            }
        } else {
            $error = $message;
        }
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Instalasi - Sistem Keuangan Terpadu</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 2rem;
        }
        .install-card {
            background: #fff;
            border-radius: 1rem;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            max-width: 600px;
            width: 100%;
        }
        .install-header {
            background: linear-gradient(135deg, #2563eb 0%, #1d4ed8 100%);
            color: #fff;
            padding: 2rem;
            border-radius: 1rem 1rem 0 0;
            text-align: center;
        }
        .install-body {
            padding: 2rem;
        }
        .requirement-item {
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 0.75rem;
            border-bottom: 1px solid #e2e8f0;
        }
        .requirement-item:last-child {
            border-bottom: none;
        }
        .status-icon {
            font-size: 1.25rem;
        }
        .status-ok { color: #10b981; }
        .status-fail { color: #ef4444; }
    </style>
</head>
<body>
    <div class="install-card">
        <div class="install-header">
            <i class="bi bi-wallet2 fs-1 mb-3"></i>
            <h3>Sistem Keuangan Terpadu</h3>
            <p class="mb-0">Wizard Instalasi</p>
        </div>
        
        <div class="install-body">
            <?php if ($step == 1): ?>
            <!-- Step 1: Check Requirements -->
            <h5 class="mb-3">1. Cek Persyaratan Sistem</h5>
            
            <?php $requirements = checkRequirements(); ?>
            
            <div class="card mb-4">
                <div class="card-body p-0">
                    <?php foreach ($requirements as $name => $met): ?>
                    <div class="requirement-item">
                        <span><?php echo $name; ?></span>
                        <i class="bi bi-<?php echo $met ? 'check-circle-fill status-ok' : 'x-circle-fill status-fail'; ?> status-icon"></i>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
            
            <?php if (in_array(false, $requirements)): ?>
            <div class="alert alert-danger">
                <i class="bi bi-exclamation-triangle-fill me-2"></i>
                Beberapa persyaratan tidak terpenuhi. Silakan perbaiki sebelum melanjutkan.
            </div>
            <?php else: ?>
            <div class="alert alert-success">
                <i class="bi bi-check-circle-fill me-2"></i>
                Semua persyaratan terpenuhi!
            </div>
            <a href="?step=2" class="btn btn-primary w-100">Lanjutkan</a>
            <?php endif; ?>
            
            <?php elseif ($step == 2): ?>
            <!-- Step 2: Database Configuration -->
            <h5 class="mb-3">2. Konfigurasi Database</h5>
            
            <?php if ($error): ?>
            <div class="alert alert-danger"><?php echo $error; ?></div>
            <?php endif; ?>
            
            <form method="POST" action="">
                <div class="mb-3">
                    <label class="form-label">Host Database</label>
                    <input type="text" class="form-control" name="db_host" value="localhost" required>
                </div>
                
                <div class="mb-3">
                    <label class="form-label">Username Database</label>
                    <input type="text" class="form-control" name="db_user" placeholder="root" required>
                </div>
                
                <div class="mb-3">
                    <label class="form-label">Password Database</label>
                    <input type="password" class="form-control" name="db_pass" placeholder="Kosongkan jika tidak ada">
                </div>
                
                <div class="mb-3">
                    <label class="form-label">Nama Database</label>
                    <input type="text" class="form-control" name="db_name" value="sistem_keuangan_terpadu" required>
                    <small class="text-muted">Database akan dibuat otomatis jika belum ada</small>
                </div>
                
                <button type="submit" class="btn btn-primary w-100">
                    <i class="bi bi-check-lg me-2"></i>Install
                </button>
            </form>
            
            <?php elseif ($step == 3): ?>
            <!-- Step 3: Success -->
            <div class="text-center">
                <i class="bi bi-check-circle-fill text-success" style="font-size: 4rem;"></i>
                <h4 class="mt-3">Instalasi Berhasil!</h4>
                <p class="text-muted"><?php echo $success; ?></p>
                
                <div class="alert alert-warning text-start">
                    <strong>Langkah selanjutnya:</strong>
                    <ol class="mb-0 mt-2">
                        <li>Hapus file <code>install.php</code></li>
                        <li>Login dengan akun default:</li>
                        <ul>
                            <li>Email: <code>admin@admin.com</code></li>
                            <li>Password: <code>admin123</code></li>
                        </ul>
                        <li>Ganti password default setelah login</li>
                    </ol>
                </div>
                
                <a href="login.php" class="btn btn-primary">Ke Halaman Login</a>
            </div>
            <?php endif; ?>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
