<?php
/**
 * Header Template
 */
require_once __DIR__ . '/../config.php';

// Check if page requires login
$publicPages = ['login.php', 'register.php', 'forgot-password.php'];
$currentPage = basename($_SERVER['PHP_SELF']);

if (!in_array($currentPage, $publicPages) && !isLoggedIn()) {
    redirect('login.php');
}

// Get user info
$user = null;
if (isLoggedIn()) {
    $db = getDB();
    $stmt = $db->prepare("SELECT * FROM users WHERE id = ?");
    $stmt->execute([$_SESSION['user_id']]);
    $user = $stmt->fetch();
}

// Get notification count
$notificationCount = 0;
if (isLoggedIn()) {
    $db = getDB();
    // Count pending payments
    $stmt = $db->query("SELECT COUNT(*) as count FROM participants WHERE payment_status = 'pending'");
    $notificationCount = $stmt->fetch()['count'];
}

// Get current business
$currentBusiness = null;
if (isLoggedIn() && isset($_SESSION['current_business_id'])) {
    $db = getDB();
    $stmt = $db->prepare("SELECT * FROM businesses WHERE id = ?");
    $stmt->execute([$_SESSION['current_business_id']]);
    $currentBusiness = $stmt->fetch();
}

// Get all businesses for user
$userBusinesses = [];
if (isLoggedIn()) {
    $db = getDB();
    $stmt = $db->prepare("
        SELECT b.* FROM businesses b
        JOIN business_users bu ON b.id = bu.business_id
        WHERE bu.user_id = ? AND b.is_active = 1
        ORDER BY b.name
    ");
    $stmt->execute([$_SESSION['user_id']]);
    $userBusinesses = $stmt->fetchAll();
    
    // If no business selected, select first one
    if (empty($currentBusiness) && !empty($userBusinesses)) {
        $_SESSION['current_business_id'] = $userBusinesses[0]['id'];
        $currentBusiness = $userBusinesses[0];
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="description" content="<?php echo APP_NAME; ?> - Sistem Manajemen Keuangan dan Event">
    <meta name="author" content="Cita Cerdas">
    <meta name="csrf-token" content="<?php echo generateCSRFToken(); ?>">
    
    <title><?php echo isset($pageTitle) ? $pageTitle . ' - ' : ''; ?><?php echo APP_NAME; ?></title>
    
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="assets/images/favicon.ico">
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Bootstrap Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js"></script>
    
    <!-- Custom CSS -->
    <style>
        :root {
            --primary-color: #2563eb;
            --primary-dark: #1d4ed8;
            --secondary-color: #64748b;
            --success-color: #10b981;
            --danger-color: #ef4444;
            --warning-color: #f59e0b;
            --info-color: #3b82f6;
            --light-bg: #f8fafc;
            --dark-bg: #1e293b;
            --sidebar-width: 260px;
            --sidebar-collapsed: 70px;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background-color: var(--light-bg);
            color: #334155;
            line-height: 1.6;
        }
        
        /* Sidebar Styles */
        .sidebar {
            position: fixed;
            top: 0;
            left: 0;
            width: var(--sidebar-width);
            height: 100vh;
            background: linear-gradient(180deg, #1e293b 0%, #0f172a 100%);
            color: #fff;
            z-index: 1000;
            transition: all 0.3s ease;
            overflow-y: auto;
        }
        
        .sidebar.collapsed {
            width: var(--sidebar-collapsed);
        }
        
        .sidebar-brand {
            padding: 1.5rem;
            border-bottom: 1px solid rgba(255,255,255,0.1);
        }
        
        .sidebar-brand h4 {
            font-weight: 700;
            font-size: 1.1rem;
            margin: 0;
        }
        
        .sidebar-brand small {
            color: rgba(255,255,255,0.6);
            font-size: 0.75rem;
        }
        
        .sidebar-menu {
            padding: 1rem 0;
        }
        
        .menu-item {
            display: flex;
            align-items: center;
            padding: 0.875rem 1.5rem;
            color: rgba(255,255,255,0.8);
            text-decoration: none;
            transition: all 0.2s ease;
            border-left: 3px solid transparent;
        }
        
        .menu-item:hover,
        .menu-item.active {
            background: rgba(255,255,255,0.05);
            color: #fff;
            border-left-color: var(--primary-color);
        }
        
        .menu-item i {
            font-size: 1.25rem;
            width: 24px;
            margin-right: 12px;
        }
        
        .menu-item span {
            font-size: 0.9rem;
            font-weight: 500;
        }
        
        .sidebar-footer {
            position: absolute;
            bottom: 0;
            left: 0;
            right: 0;
            padding: 1rem;
            border-top: 1px solid rgba(255,255,255,0.1);
        }
        
        .user-info {
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .user-avatar {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: var(--primary-color);
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 600;
            font-size: 0.9rem;
        }
        
        .user-details {
            flex: 1;
            min-width: 0;
        }
        
        .user-name {
            font-weight: 600;
            font-size: 0.9rem;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }
        
        .user-role {
            font-size: 0.75rem;
            color: rgba(255,255,255,0.6);
            text-transform: capitalize;
        }
        
        /* Main Content */
        .main-content {
            margin-left: var(--sidebar-width);
            min-height: 100vh;
            transition: all 0.3s ease;
        }
        
        .sidebar.collapsed + .main-content {
            margin-left: var(--sidebar-collapsed);
        }
        
        /* Top Navbar */
        .top-navbar {
            background: #fff;
            padding: 1rem 1.5rem;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
            display: flex;
            align-items: center;
            justify-content: space-between;
            position: sticky;
            top: 0;
            z-index: 100;
        }
        
        .navbar-left {
            display: flex;
            align-items: center;
            gap: 1rem;
        }
        
        .toggle-sidebar {
            background: none;
            border: none;
            font-size: 1.5rem;
            color: var(--secondary-color);
            cursor: pointer;
            padding: 0.25rem;
        }
        
        .page-title {
            font-size: 1.25rem;
            font-weight: 600;
            color: #1e293b;
            margin: 0;
        }
        
        .navbar-right {
            display: flex;
            align-items: center;
            gap: 1rem;
        }
        
        .nav-btn {
            position: relative;
            background: none;
            border: none;
            font-size: 1.25rem;
            color: var(--secondary-color);
            cursor: pointer;
            padding: 0.5rem;
            border-radius: 0.5rem;
            transition: all 0.2s ease;
        }
        
        .nav-btn:hover {
            background: var(--light-bg);
            color: var(--primary-color);
        }
        
        .nav-btn .badge {
            position: absolute;
            top: 0;
            right: 0;
            font-size: 0.65rem;
        }
        
        /* Content Area */
        .content-area {
            padding: 1.5rem;
        }
        
        /* Cards */
        .card {
            border: none;
            border-radius: 0.75rem;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
            transition: all 0.2s ease;
        }
        
        .card:hover {
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        }
        
        .card-header {
            background: transparent;
            border-bottom: 1px solid #e2e8f0;
            padding: 1rem 1.25rem;
        }
        
        .card-title {
            font-weight: 600;
            color: #1e293b;
            margin: 0;
        }
        
        /* Stats Cards */
        .stat-card {
            padding: 1.5rem;
            border-radius: 0.75rem;
            color: #fff;
            position: relative;
            overflow: hidden;
        }
        
        .stat-card::before {
            content: '';
            position: absolute;
            top: -50%;
            right: -20%;
            width: 200px;
            height: 200px;
            background: rgba(255,255,255,0.1);
            border-radius: 50%;
        }
        
        .stat-card.primary { background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%); }
        .stat-card.success { background: linear-gradient(135deg, #10b981 0%, #059669 100%); }
        .stat-card.warning { background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%); }
        .stat-card.danger { background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%); }
        .stat-card.info { background: linear-gradient(135deg, #06b6d4 0%, #0891b2 100%); }
        .stat-card.secondary { background: linear-gradient(135deg, #64748b 0%, #475569 100%); }
        
        .stat-icon {
            font-size: 2.5rem;
            opacity: 0.8;
            margin-bottom: 1rem;
        }
        
        .stat-value {
            font-size: 2rem;
            font-weight: 700;
            margin-bottom: 0.25rem;
        }
        
        .stat-label {
            font-size: 0.875rem;
            opacity: 0.9;
        }
        
        /* Tables */
        .table-container {
            background: #fff;
            border-radius: 0.75rem;
            overflow: hidden;
        }
        
        .table {
            margin: 0;
        }
        
        .table thead th {
            background: #f8fafc;
            font-weight: 600;
            font-size: 0.8rem;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            color: #64748b;
            border: none;
            padding: 1rem;
        }
        
        .table tbody td {
            padding: 1rem;
            vertical-align: middle;
            border-color: #f1f5f9;
        }
        
        .table tbody tr:hover {
            background: #f8fafc;
        }
        
        /* Badges */
        .badge {
            padding: 0.5em 0.75em;
            font-weight: 500;
            font-size: 0.75rem;
        }
        
        .badge-draft { background: #e2e8f0; color: #475569; }
        .badge-dibuka { background: #dbeafe; color: #1e40af; }
        .badge-tertutup { background: #fef3c7; color: #92400e; }
        .badge-selesai { background: #d1fae5; color: #065f46; }
        .badge-dibatalkan { background: #fee2e2; color: #991b1b; }
        
        .badge-pending { background: #fef3c7; color: #92400e; }
        .badge-paid { background: #d1fae5; color: #065f46; }
        .badge-refunded { background: #e0e7ff; color: #3730a3; }
        
        /* Buttons */
        .btn {
            font-weight: 500;
            padding: 0.625rem 1rem;
            border-radius: 0.5rem;
            transition: all 0.2s ease;
        }
        
        .btn-primary {
            background: var(--primary-color);
            border-color: var(--primary-color);
        }
        
        .btn-primary:hover {
            background: var(--primary-dark);
            border-color: var(--primary-dark);
        }
        
        /* Forms */
        .form-control, .form-select {
            border-radius: 0.5rem;
            border-color: #e2e8f0;
            padding: 0.625rem 0.875rem;
        }
        
        .form-control:focus, .form-select:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 3px rgba(37, 99, 235, 0.1);
        }
        
        .form-label {
            font-weight: 500;
            font-size: 0.875rem;
            color: #475569;
        }
        
        /* Alerts */
        .alert {
            border: none;
            border-radius: 0.5rem;
            padding: 1rem 1.25rem;
        }
        
        /* Pagination */
        .pagination {
            margin: 0;
        }
        
        .page-link {
            border: none;
            color: var(--secondary-color);
            padding: 0.5rem 0.75rem;
            border-radius: 0.375rem;
            margin: 0 0.125rem;
        }
        
        .page-link:hover {
            background: var(--light-bg);
            color: var(--primary-color);
        }
        
        .page-item.active .page-link {
            background: var(--primary-color);
            color: #fff;
        }
        
        /* Mobile Responsive */
        @media (max-width: 991.98px) {
            .sidebar {
                transform: translateX(-100%);
            }
            
            .sidebar.show {
                transform: translateX(0);
            }
            
            .main-content {
                margin-left: 0;
            }
            
            .sidebar-overlay {
                display: none;
                position: fixed;
                top: 0;
                left: 0;
                right: 0;
                bottom: 0;
                background: rgba(0,0,0,0.5);
                z-index: 999;
            }
            
            .sidebar-overlay.show {
                display: block;
            }
        }
        
        /* Print Styles */
        @media print {
            .sidebar, .top-navbar, .no-print {
                display: none !important;
            }
            
            .main-content {
                margin-left: 0 !important;
            }
        }
        
        /* Animations */
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        .fade-in {
            animation: fadeIn 0.3s ease forwards;
        }
        
        /* Custom Scrollbar */
        ::-webkit-scrollbar {
            width: 8px;
            height: 8px;
        }
        
        ::-webkit-scrollbar-track {
            background: #f1f5f9;
        }
        
        ::-webkit-scrollbar-thumb {
            background: #cbd5e1;
            border-radius: 4px;
        }
        
        ::-webkit-scrollbar-thumb:hover {
            background: #94a3b8;
        }
    </style>
</head>
<body>
    <?php if (isLoggedIn()): ?>
    <!-- Sidebar Overlay (Mobile) -->
    <div class="sidebar-overlay" id="sidebarOverlay" onclick="toggleSidebar()"></div>
    
    <!-- Sidebar -->
    <aside class="sidebar" id="sidebar">
        <div class="sidebar-brand">
            <h4><i class="bi bi-wallet2 me-2"></i><?php echo APP_NAME; ?></h4>
            <small>Versi <?php echo APP_VERSION; ?></small>
        </div>
        
        <nav class="sidebar-menu">
            <?php 
            $menuItems = [
                ['id' => 'dashboard', 'label' => 'Dashboard', 'icon' => 'bi-speedometer2', 'roles' => ['owner', 'admin', 'finance', 'event_manager']],
                ['id' => 'events', 'label' => 'Manajemen Event', 'icon' => 'bi-calendar-event', 'roles' => ['owner', 'admin', 'event_manager']],
                ['id' => 'participants', 'label' => 'Peserta', 'icon' => 'bi-people', 'roles' => ['owner', 'admin', 'event_manager']],
                ['id' => 'transactions', 'label' => 'Transaksi', 'icon' => 'bi-cash-stack', 'roles' => ['owner', 'admin', 'finance']],
                ['id' => 'analytics', 'label' => 'Analitik', 'icon' => 'bi-graph-up', 'roles' => ['owner', 'admin', 'finance', 'event_manager']],
                ['id' => 'recommendations', 'label' => 'Rekomendasi', 'icon' => 'bi-lightbulb', 'roles' => ['owner', 'admin']],
                ['id' => 'reports', 'label' => 'Laporan', 'icon' => 'bi-file-earmark-text', 'roles' => ['owner', 'admin', 'finance']],
                ['id' => 'settings', 'label' => 'Pengaturan', 'icon' => 'bi-gear', 'roles' => ['owner', 'admin']],
            ];
            
            $currentPageId = basename($_SERVER['PHP_SELF'], '.php');
            
            foreach ($menuItems as $item): 
                if (in_array($_SESSION['user_role'], $item['roles'])):
                    $isActive = $currentPageId === $item['id'] ? 'active' : '';
            ?>
            <a href="<?php echo $item['id']; ?>.php" class="menu-item <?php echo $isActive; ?>">
                <i class="bi <?php echo $item['icon']; ?>"></i>
                <span><?php echo $item['label']; ?></span>
            </a>
            <?php 
                endif;
            endforeach; 
            ?>
        </nav>
        
        <div class="sidebar-footer">
            <div class="user-info mb-3">
                <div class="user-avatar">
                    <?php echo strtoupper(substr($user['name'], 0, 1)); ?>
                </div>
                <div class="user-details">
                    <div class="user-name"><?php echo htmlspecialchars($user['name']); ?></div>
                    <div class="user-role"><?php echo str_replace('_', ' ', $user['role']); ?></div>
                </div>
            </div>
            <a href="logout.php" class="btn btn-outline-light btn-sm w-100">
                <i class="bi bi-box-arrow-left me-2"></i>Logout
            </a>
        </div>
    </aside>
    
    <!-- Main Content -->
    <main class="main-content">
        <!-- Top Navbar -->
        <header class="top-navbar">
            <div class="navbar-left">
                <button class="toggle-sidebar d-lg-none" onclick="toggleSidebar()">
                    <i class="bi bi-list"></i>
                </button>
                <h1 class="page-title"><?php echo isset($pageTitle) ? $pageTitle : 'Dashboard'; ?></h1>
            </div>
            
            <div class="navbar-right">
                <!-- Business Selector -->
                <?php if (count($userBusinesses) > 1): ?>
                <div class="dropdown">
                    <button class="btn btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                        <i class="bi bi-building me-2"></i>
                        <?php echo $currentBusiness ? htmlspecialchars($currentBusiness['name']) : 'Pilih Bisnis'; ?>
                    </button>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <?php foreach ($userBusinesses as $biz): ?>
                        <li>
                            <a class="dropdown-item <?php echo $currentBusiness && $currentBusiness['id'] == $biz['id'] ? 'active' : ''; ?>" 
                               href="switch-business.php?id=<?php echo $biz['id']; ?>&redirect=<?php echo urlencode($_SERVER['REQUEST_URI']); ?>">
                                <?php echo htmlspecialchars($biz['name']); ?>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
                <?php endif; ?>
                
                <!-- Notifications -->
                <button class="nav-btn" onclick="location.href='participants.php?status=pending'">
                    <i class="bi bi-bell"></i>
                    <?php if ($notificationCount > 0): ?>
                    <span class="badge bg-danger rounded-pill"><?php echo $notificationCount; ?></span>
                    <?php endif; ?>
                </button>
                
                <!-- Help -->
                <button class="nav-btn" onclick="location.href='help.php'">
                    <i class="bi bi-question-circle"></i>
                </button>
            </div>
        </header>
        
        <!-- Content Area -->
        <div class="content-area">
            <?php showFlash(); ?>
    <?php endif; ?>
