    <?php if (isLoggedIn()): ?>
        </div><!-- /content-area -->
    </main><!-- /main-content -->
    <?php endif; ?>
    
    <!-- Bootstrap 5 JS Bundle -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Custom JavaScript -->
    <script>
        // Toggle Sidebar (Mobile)
        function toggleSidebar() {
            const sidebar = document.getElementById('sidebar');
            const overlay = document.getElementById('sidebarOverlay');
            sidebar.classList.toggle('show');
            overlay.classList.toggle('show');
        }
        
        // Auto-hide alerts after 5 seconds
        document.addEventListener('DOMContentLoaded', function() {
            const alerts = document.querySelectorAll('.alert-dismissible');
            alerts.forEach(function(alert) {
                setTimeout(function() {
                    const bsAlert = new bootstrap.Alert(alert);
                    bsAlert.close();
                }, 5000);
            });
        });
        
        // Confirm delete
        function confirmDelete(message = 'Apakah Anda yakin ingin menghapus data ini?') {
            return confirm(message);
        }
        
        // Format currency input
        function formatCurrency(input) {
            let value = input.value.replace(/[^\d]/g, '');
            if (value) {
                input.value = 'Rp ' + parseInt(value).toLocaleString('id-ID');
            } else {
                input.value = '';
            }
        }
        
        // Parse currency to number
        function parseCurrency(value) {
            return parseInt(value.replace(/[^\d]/g, '')) || 0;
        }
        
        // Print function
        function printPage() {
            window.print();
        }
        
        // Export table to CSV
        function exportTableToCSV(tableId, filename) {
            const table = document.getElementById(tableId);
            if (!table) return;
            
            let csv = [];
            const rows = table.querySelectorAll('tr');
            
            rows.forEach(function(row) {
                let cols = row.querySelectorAll('td, th');
                let rowData = [];
                
                cols.forEach(function(col) {
                    let data = col.innerText.replace(/"/g, '""');
                    rowData.push('"' + data + '"');
                });
                
                csv.push(rowData.join(','));
            });
            
            downloadCSV(csv.join('\n'), filename);
        }
        
        function downloadCSV(csv, filename) {
            const blob = new Blob([csv], { type: 'text/csv;charset=utf-8;' });
            const link = document.createElement('a');
            
            if (link.download !== undefined) {
                const url = URL.createObjectURL(blob);
                link.setAttribute('href', url);
                link.setAttribute('download', filename);
                link.style.visibility = 'hidden';
                document.body.appendChild(link);
                link.click();
                document.body.removeChild(link);
            }
        }
        
        // AJAX helper
        function ajaxRequest(url, method, data, callback) {
            const xhr = new XMLHttpRequest();
            xhr.open(method, url, true);
            xhr.setRequestHeader('X-Requested-With', 'XMLHttpRequest');
            
            if (method === 'POST') {
                xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
            }
            
            xhr.onreadystatechange = function() {
                if (xhr.readyState === 4 && xhr.status === 200) {
                    callback(xhr.responseText);
                }
            };
            
            xhr.send(data);
        }
        
        // Debounce function
        function debounce(func, wait) {
            let timeout;
            return function executedFunction(...args) {
                const later = () => {
                    clearTimeout(timeout);
                    func(...args);
                };
                clearTimeout(timeout);
                timeout = setTimeout(later, wait);
            };
        }
        
        // Search table
        function searchTable(inputId, tableId) {
            const input = document.getElementById(inputId);
            const table = document.getElementById(tableId);
            
            if (!input || !table) return;
            
            input.addEventListener('keyup', debounce(function() {
                const filter = input.value.toLowerCase();
                const rows = table.querySelectorAll('tbody tr');
                
                rows.forEach(function(row) {
                    const text = row.textContent.toLowerCase();
                    row.style.display = text.includes(filter) ? '' : 'none';
                });
            }, 300));
        }
        
        // Initialize tooltips
        document.addEventListener('DOMContentLoaded', function() {
            const tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
            tooltipTriggerList.map(function(tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl);
            });
        });
        
        // Calculate event metrics (client-side)
        function calculateEventMetrics() {
            const price = parseFloat(document.getElementById('price')?.value) || 0;
            const capacity = parseInt(document.getElementById('capacity')?.value) || 0;
            const fixedCost = parseFloat(document.getElementById('fixed_cost')?.value) || 0;
            const variableCost = parseFloat(document.getElementById('variable_cost_per_participant')?.value) || 0;
            
            const expectedRevenue = price * capacity;
            const expectedCost = fixedCost + (variableCost * capacity);
            const expectedMargin = expectedRevenue - expectedCost;
            const marginPercent = expectedRevenue > 0 ? (expectedMargin / expectedRevenue * 100).toFixed(2) : 0;
            const breakEvenPrice = capacity > 0 ? Math.ceil(expectedCost / capacity) : 0;
            
            // Update display if elements exist
            const revenueEl = document.getElementById('expected_revenue');
            const costEl = document.getElementById('expected_cost');
            const marginEl = document.getElementById('expected_margin');
            const marginPercentEl = document.getElementById('margin_percent');
            const breakEvenEl = document.getElementById('break_even_price');
            
            if (revenueEl) revenueEl.textContent = 'Rp ' + expectedRevenue.toLocaleString('id-ID');
            if (costEl) costEl.textContent = 'Rp ' + expectedCost.toLocaleString('id-ID');
            if (marginEl) marginEl.textContent = 'Rp ' + expectedMargin.toLocaleString('id-ID');
            if (marginPercentEl) marginPercentEl.textContent = marginPercent + '%';
            if (breakEvenEl) breakEvenEl.textContent = 'Rp ' + breakEvenPrice.toLocaleString('id-ID');
        }
        
        // Add event listeners for calculation
        document.addEventListener('DOMContentLoaded', function() {
            const calcInputs = ['price', 'capacity', 'fixed_cost', 'variable_cost_per_participant'];
            calcInputs.forEach(function(id) {
                const el = document.getElementById(id);
                if (el) {
                    el.addEventListener('input', calculateEventMetrics);
                }
            });
        });
    </script>
</body>
</html>
