# Troubleshooting Login

## Masalah: Tidak Bisa Login

### Solusi 1: Fix Password via SQL (Cepat)

1. Buka **phpMyAdmin**
2. Pilih database `sistem_keuangan_terpadu`
3. Klik tab **SQL**
4. Jalankan query berikut:

```sql
UPDATE users SET 
    password = '$2b$12$U2OSeatZ1jgZOYKgoXDk8uc6hq3wUpqRlrdwuBTM0.iffpFZzMtoC',
    login_attempts = 0,
    locked_until = NULL,
    is_active = 1
WHERE email = 'admin@admin.com';
```

5. Coba login kembali dengan:
   - Email: `admin@admin.com`
   - Password: `admin123`

---

### Solusi 2: Gunakan Reset Password Script

1. Buka browser, akses: `https://domain.com/sistem-keuangan/reset-password.php`
2. Masukkan email: `admin@admin.com`
3. Masukkan password baru: `admin123`
4. Klik **Reset Password**
5. Hapus file `reset-password.php` setelah digunakan!

---

### Solusi 3: Debug Mode

1. Buka login page dengan parameter debug:
   ```
   https://domain.com/sistem-keuangan/login.php?debug=1
   ```

2. Coba login dengan akun yang benar
3. Sistem akan menampilkan informasi debug untuk membantu diagnosis

---

### Solusi 4: Import Ulang Database

1. Hapus semua tabel di database
2. Import ulang file `database.sql`
3. Coba login dengan akun default

---

## Akun Default

| Email | Password | Role |
|-------|----------|------|
| admin@admin.com | admin123 | Owner |
| owner@demo.com | demo123 | Owner |
| admin@demo.com | demo123 | Admin |
| finance@demo.com | demo123 | Finance |
| event@demo.com | demo123 | Event Manager |

---

## Masalah Umum & Solusi

### "Email atau password salah"
- Pastikan email benar (case sensitive)
- Pastikan password benar (tanpa spasi)
- Cek apakah user `is_active = 1` di database

### "Akun terkunci"
- Tunggu 15 menit atau jalankan:
  ```sql
  UPDATE users SET login_attempts = 0, locked_until = NULL WHERE email = 'admin@admin.com';
  ```

### "Invalid CSRF token"
- Refresh halaman login
- Clear browser cache & cookies
- Coba browser lain

### "Database error"
- Cek konfigurasi `config.php`
- Pastikan database name, user, password benar
- Pastikan MySQL server berjalan

---

## Cek Manual via phpMyAdmin

1. Buka tabel `users`
2. Cek kolom:
   - `email` = 'admin@admin.com'
   - `is_active` = 1
   - `password` tidak kosong
   - `locked_until` = NULL atau tanggal sudah lewat
   - `login_attempts` < 5

3. Jika perlu, update manual:
   ```sql
   UPDATE users SET 
       password = '$2b$12$U2OSeatZ1jgZOYKgoXDk8uc6hq3wUpqRlrdwuBTM0.iffpFZzMtoC',
       is_active = 1,
       login_attempts = 0,
       locked_until = NULL
   WHERE email = 'admin@admin.com';
   ```

---

## Generate Hash Baru

Jika ingin membuat password sendiri, gunakan PHP:

```php
<?php
$password = 'password_anda';
$hash = password_hash($password, PASSWORD_BCRYPT, ['cost' => 12]);
echo $hash;
?>
```

Lalu copy hash ke database.

---

## Masih Bermasalah?

1. Cek error log di `config.php` - pastikan `display_errors = 1`
2. Cek browser console (F12) untuk error JavaScript
3. Pastikan semua file ter-upload dengan benar
4. Cek permission folder (biasanya 755 untuk folder, 644 untuk file)
