# Sistem Keuangan Terpadu

Aplikasi web lengkap untuk manajemen keuangan dan event/arena kompetisi. Dibangun dengan PHP dan MySQL, siap untuk di-hosting.

## Fitur Utama

### Manajemen Event
- ✅ Buat, edit, hapus event (olimpiade, kompetisi, workshop, seminar)
- ✅ Status event: draft, dibuka, tertutup, selesai, dibatalkan
- ✅ Kapasitas peserta, harga tiket, biaya tetap & variabel
- ✅ Perhitungan otomatis: revenue, cost, margin, ROI

### Registrasi & Peserta
- ✅ Form pendaftaran lengkap (nama, sekolah, kelas, kontak)
- ✅ Tracking status pembayaran (pending, paid, refunded)
- ✅ Kode registrasi unik
- ✅ Catat kehadiran

### Keuangan
- ✅ Catat semua transaksi (income/expense)
- ✅ Kategori transaksi
- ✅ Kalkulasi otomatis margin dan ROI
- ✅ Grafik pemasukan vs pengeluaran

### Analitik & Grafik
- ✅ Dashboard dengan ringkasan statistik
- ✅ Grafik peserta per bulan
- ✅ Grafik revenue vs cost
- ✅ Grafik margin per event
- ✅ Scatter plot margin vs ROI

### Rekomendasi Event
- ✅ Sistem scoring untuk memilih event layak dijalankan
- ✅ Prediksi peserta dan margin
- ✅ Perhitungan break-even
- ✅ Deteksi konflik jadwal

### Laporan & Export
- ✅ Filter by periode dan event
- ✅ Export CSV
- ✅ Print-friendly

### Keamanan & Multi-user
- ✅ Role-based access: Owner, Admin, Finance, Event Manager
- ✅ CSRF protection
- ✅ SQL injection prevention
- ✅ Login attempt limiting
- ✅ Session security

### Backup & Restore
- ✅ Backup database
- ✅ Download file backup

## Persyaratan Sistem

- PHP 7.4 atau lebih baru
- MySQL 5.7 atau lebih baru
- Web server (Apache/Nginx)
- Ekstensi PHP: PDO, PDO_MySQL

## Cara Install

### 1. Upload File
Upload semua file ke direktori web server Anda (misal: `public_html/sistem-keuangan/`)

### 2. Buat Database
1. Buka phpMyAdmin
2. Buat database baru (misal: `sistem_keuangan_terpadu`)
3. Import file `database.sql`

### 3. Konfigurasi Database
Edit file `config.php` dan sesuaikan:

```php
define('DB_HOST', 'localhost');
define('DB_USER', 'username_database');
define('DB_PASS', 'password_database');
define('DB_NAME', 'nama_database');
```

### 4. Akses Aplikasi
Buka browser dan akses URL aplikasi Anda.

**Default Login:**
- Email: `admin@admin.com`
- Password: `admin123`

**Demo Login (Cepat):**
- Owner: `owner@demo.com` / `demo123`
- Admin: `admin@demo.com` / `demo123`
- Finance: `finance@demo.com` / `demo123`
- Event Manager: `event@demo.com` / `demo123`

## Struktur Folder

```
sistem-keuangan-terpadu/
├── assets/                 # CSS, JS, images
├── backup/                 # File backup
├── exports/                # File export
├── includes/               # Header & footer
├── uploads/                # File uploads
├── config.php             # Konfigurasi utama
├── database.sql           # Schema database
├── index.php              # Entry point
├── login.php              # Halaman login
├── logout.php             # Logout handler
├── dashboard.php          # Dashboard
├── events.php             # Manajemen event
├── participants.php       # Manajemen peserta
├── transactions.php       # Manajemen transaksi
├── analytics.php          # Analitik
├── recommendations.php    # Rekomendasi event
├── reports.php            # Laporan
├── settings.php           # Pengaturan
└── README.md              # Dokumentasi
```

## Hak Akses per Role

| Fitur | Owner | Admin | Finance | Event Manager |
|-------|-------|-------|---------|---------------|
| Dashboard | ✅ | ✅ | ✅ | ✅ |
| Event (CRUD) | ✅ | ✅ | ❌ | ✅ |
| Peserta | ✅ | ✅ | ❌ | ✅ |
| Transaksi | ✅ | ✅ | ✅ | ❌ |
| Analitik | ✅ | ✅ | ✅ | ✅ |
| Rekomendasi | ✅ | ✅ | ❌ | ❌ |
| Laporan | ✅ | ✅ | ✅ | ❌ |
| Pengaturan | ✅ | ✅ | ❌ | ❌ |

## Keamanan

Aplikasi ini dilengkapi dengan:
- CSRF Token pada semua form
- Prepared statements untuk mencegah SQL injection
- Password hashing dengan bcrypt
- Session security (httponly, secure cookie)
- Login attempt limiting (5 kali gagal = lockout 15 menit)
- XSS protection dengan htmlspecialchars

## Rumus Perhitungan

### Event Metrics
```
total_revenue = SUM(paid_amount dari peserta yang sudah bayar)
total_cost = fixed_cost + (variable_cost_per_participant × total_participants)
gross_margin = total_revenue - total_cost
margin_percent = (gross_margin / total_revenue) × 100
roi = (gross_margin / total_cost) × 100
profit_per_participant = gross_margin / total_participants
```

### Break-even Price
```
break_even_price = total_cost / expected_participants
```

### Event Recommendation Score
```
score = (0.30 × normalized_participants) +
        (0.30 × normalized_margin) +
        (0.20 × attendance_rate) +
        (0.15 × marketing_reach) -
        (0.05 × conflict_score)
```

## Troubleshooting

### Error: "Koneksi database gagal"
- Periksa konfigurasi DB_HOST, DB_USER, DB_PASS, DB_NAME di config.php
- Pastikan MySQL server berjalan

### Error: "Access denied"
- Pastikan user memiliki role yang sesuai
- Cek tabel `business_users` untuk relasi user-business

### Halaman blank/putih
- Aktifkan error reporting di config.php: `ini_set('display_errors', 1);`
- Cek error log server

## Lisensi

Copyright © 2024 Cita Cerdas. All rights reserved.

## Dukungan

Untuk bantuan dan pertanyaan, silakan hubungi:
- Email: support@citacerdas.id
- WhatsApp: 0812-XXXX-XXXX
